//Experiment Number:1 
//Write a program to perform Amplitude modulation and demodulation and study its spectral characteristics
//Analog and Digital Communication Laboratory 
//B.Tech II Year II Sem
//Student Name:               Enrolment Number:  
// Course Instructor: Aqeel Shaik
// Sreyas Institute Of Engineering & Technology, Hyderabad.
//-------------------------------------------------------------------------------//


// OS : Windows 10.1
// Scilab 6.0.2

clc;
clear;
close;
fm=3;    // Message freq
fc=20;  // Carrier freq
fs=100
t=0:1/fs :3;
p=length(t);
am=input('Enter the message signal amplitude=');
ac=input('Enter the carrier signal amplitude (ac>am)=');

// Message Signal Generation

msg=am*cos(2*%pi*fm*t); 

figure(1);
subplot(3,1,1);
plot(t,msg);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Message Signal');

//Carrier Signal generation
carrier=ac*cos(2*%pi*fc*t);
subplot(3,1,2);
plot(t,carrier);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Carrier Signal');

ka=1/ac; //Amplitude sensitivity of the modulator
u=ka*am;
disp(u,'The Modulation Index is')

//Amplitude Modulation Generation

am_mod=(1+ka.*msg).*carrier;
subplot(3,1,3);
plot(t,am_mod);
xlabel('TIME');
ylabel('AMPLITUDE')
title('Amplitude Modulated Signal')

// Frqeuncy Spectrum
d=(-p/2:1:p/2-1)*1/3;// Indexing
figure(2)
subplot(3,1,1);
plot(d,abs(fftshift(fft(am_mod))));// FOURIER TRANSFORM OF MODULATED SIGNAL
xlabel('FREQUENCY');
ylabel('AMPLITUDE')
title('AM Signal Spectrum')


//Demodulation of AM Signal
demod=am_mod.*carrier;
k=abs(fft(demod));
filt = [ones(1,4*fm), zeros(1,p-4*fm) ];
out=k.*filt;
subplot(3,1,3);
plot(t,ifft(out));
xlabel('TIME');
ylabel('AMPLITUDE');
title('Demodulated Message')

//Sample Inputs for the Program

//Enter the message signal amplitude=1

//Enter the carrier signal amplitude (ac>am)=2


// The Modulation Index is

 //  0.5

